//////////////////////////////////////
//                                  //
//      fourstatebutton.js          // 
//                                  //
//////////////////////////////////////

var inNetscape4x = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) < 5);
var FOUR_STATE_BUTTON_TYPE_BEEN_THERE = 0;
var FOUR_STATE_BUTTON_TYPE_DISABLE = 1;
var FOUR_STATE_BUTTON_ARRAY = new Array();
var FOUR_STATE_BUTTON_STATE_NORMAL = 0;
var FOUR_STATE_BUTTON_STATE_OVER = 1;
var FOUR_STATE_BUTTON_STATE_DOWN = 2;
var FOUR_STATE_BUTTON_STATE_DISABLED = 3;
var FOUR_STATE_BUTTON_STATE_BEEN_THERE = 3;

function fourStateButton(buttonName, buttonType, altText)
{
	var layerRef = getLayerRef(buttonName);
	layerRef.layerArray = new Array();
	layerRef.isVis = getLayerVisibility(layerRef);
	for (var i=0;i<4;i++)
	{
		layerRef.layerArray[i] = getLayerRef(buttonName + (i+1));
		setLayerVisibility(layerRef.layerArray[i],layerRef.isVis);
	}
	layerRef.buttonID = FOUR_STATE_BUTTON_ARRAY.length;
	FOUR_STATE_BUTTON_ARRAY[layerRef.buttonID] = layerRef;
	var imgRef = getImageRef(buttonName.toLowerCase());
	
	if ( inNetscape4x )
	{
		layerRef.captureEvents(Event.CLICK | Event.MOUSEOVER | Event.MOUSEUP | Event.MOUSEOUT | Event.MOUSEDOWN);
	}
	
	layerRef.buttonType = buttonType;
	layerRef.theImage = imgRef;
	if (altText != null)
	{
		layerRef.altText = altText;
		if (layerRef.theImage.alt != null)
		{
			layerRef.theImage.alt = layerRef.altText;
		}
	}
	else
	{
		if (layerRef.theImage.alt != null)
		{
			layerRef.altText = layerRef.theImage.alt;
		}
		else
		{
			layerRef.altText = "";
		}
	}
	layerRef.disableButton = fourStateDisableButton;
	layerRef.enableButton = fourStateEnableButton;
	layerRef.setOnClick = fourStateSetOnClick;
	layerRef.setOnOver = fourStateSetOnMouseOver;
	layerRef.setOnOut = fourStateSetOnMouseOut;
	layerRef.setOnDown = fourStateSetOnMouseDown;
	layerRef.setOnUp = fourStateSetOnMouseUp;
	layerRef.setState = setFourStateButtonState;
	layerRef.hide = hideFourStateButton;
	layerRef.show = showFourStateButton;
	layerRef.getVisibility = fourStateGetVisibility;
	layerRef.setVisibility = fourStateSetVisibility;	

	layerRef.state = FOUR_STATE_BUTTON_STATE_NORMAL;
	layerRef.fClick = null;
	layerRef.fOver = null;
	layerRef.fOut = null;
	layerRef.fDown = null;
	layerRef.fUp = null;
	layerRef.enabled = true;
	layerRef.beenThere = false;
		
	if (inNetscape4x)
	{
		// Do Netscape 4.5 Stuff
		layerRef.onmouseover = new Function("", "fourStateButtonMouseOver(" + layerRef.buttonID + ")");
		layerRef.onmouseout = new Function("", "fourStateButtonMouseOut(" + layerRef.buttonID + ")");
		layerRef.onmousedown = new Function("", "fourStateButtonMouseDown(" + layerRef.buttonID + ")");
		layerRef.onmouseup = new Function("", "fourStateButtonMouseUp(" + layerRef.buttonID + ")");
		layerRef.onclick = new Function("", "fourStateButtonClick(" + layerRef.buttonID + ")");	
	}
	else
	{
		// Do non-Netscape 4.5 Stuff
		layerRef.theImage.onmouseover = fourStateButtonMouseOver;
		layerRef.theImage.onmouseout = fourStateButtonMouseOut;
		layerRef.theImage.onmousedown = fourStateButtonMouseDown;
		layerRef.theImage.onmouseup = fourStateButtonMouseUp;
		layerRef.theImage.onclick = fourStateButtonClick;	
		layerRef.theImage.onfocus = fourStateButtonFocus;
		layerRef.theImage.theLayer = layerRef;
	}
	layerRef.setState(layerRef.state);
	return layerRef
}

function fourStateGetVisibility()
{
	return this.isVis;
}

function fourStateSetVisibility(flag)
{
	this.isVis = flag;
	setLayerVisibility(this, this.isVis);
	for (var i=0;i<4;i++)
	{
		if (i == this.state)
		{
			setLayerVisibility(this.layerArray[i],this.isVis);
		}
	}
}

function fourStateDisableButton()
{
	if (this.buttonType == FOUR_STATE_BUTTON_TYPE_DISABLE)
	{
		this.enabled=true;
		this.setState(FOUR_STATE_BUTTON_STATE_DISABLED);
		this.enabled=false;
	}
}

function fourStateEnableButton()
{
	if (this.buttonType == FOUR_STATE_BUTTON_TYPE_DISABLE)
	{
		this.enabled=true;
		this.setState(FOUR_STATE_BUTTON_STATE_NORMAL);
	}
}

function fourStateButtonFocus()
{
	this.theImage.blur;
}

function fourStateButtonClick(e)
{
	var theButton;
	if ( inNetscape4x )
	{
		theButton = FOUR_STATE_BUTTON_ARRAY[e];
	}
	else
	{
		theButton = this.theLayer;
	}

	if ( theButton.enabled )
	{
		if (theButton.buttonType == FOUR_STATE_BUTTON_TYPE_BEEN_THERE)
		{
			theButton.beenThere = true;
		}
	
		if ( theButton.fClick != null )
		{
			theButton.fClick(theButton.buttonId);
		}
	}
}

function fourStateButtonMouseOver(e)
{

	var theButton;
	if ( inNetscape4x )
	{
		theButton = FOUR_STATE_BUTTON_ARRAY[e];
	}
	else
	{
		theButton = this.theLayer;
	}
	window.status = theButton.altText;
	
	if ( theButton.enabled )
	{
		theButton.state = FOUR_STATE_BUTTON_STATE_OVER;
		if (theButton.isVis)
		{
			showLayer(theButton.layerArray[theButton.state]);
		}
		for (var i=0;i<theButton.layerArray.length;i++)
		{
			if (i != theButton.state)
			{
				hideLayer(theButton.layerArray[i]);
			}
		}
		if ( theButton.fOver != null )
		{
			theButton.fOver(theButton.buttonId);
		}
	}
	
	return true;
}

function fourStateButtonMouseOut(e)
{
	var theButton;
	if ( inNetscape4x )
	{
		theButton = FOUR_STATE_BUTTON_ARRAY[e];
	}
	else
	{
		theButton = this.theLayer;
	}
		
	if ( theButton.enabled )
	{
		if ( theButton.beenThere && theButton.buttonType == FOUR_STATE_BUTTON_TYPE_BEEN_THERE)
		{
			theButton.state = FOUR_STATE_BUTTON_STATE_BEEN_THERE;
			if (theButton.isVis)
			{
				showLayer(theButton.layerArray[theButton.state]);
			}
			for (var i=0;i<theButton.layerArray.length;i++)
			{
				if (i != theButton.state)
				{
					hideLayer(theButton.layerArray[i]);
				}
			}
		}
		else
		{
			theButton.state = FOUR_STATE_BUTTON_STATE_NORMAL;
			if (theButton.isVis)
			{
				showLayer(theButton.layerArray[theButton.state]);
			}
			for (var i=0;i<theButton.layerArray.length;i++)
			{
				if (i != theButton.state)
				{
					hideLayer(theButton.layerArray[i]);
				}
			}
		}
		if ( theButton.fOut != null )
		{
			theButton.fOut(theButton.buttonId);
		}
	}
	
	window.status = "";
	
	return true;
}

function fourStateButtonMouseUp(e)
{

	var theButton;
	if ( inNetscape4x )
	{
		theButton = FOUR_STATE_BUTTON_ARRAY[e];
	}
	else
	{
		theButton = this.theLayer;
	}
	
	if ( theButton.enabled )
	{
		theButton.state = FOUR_STATE_BUTTON_STATE_OVER;
		if (theButton.isVis)
		{
			showLayer(theButton.layerArray[theButton.state]);
		}
		for (var i=0;i<theButton.layerArray.length;i++)
		{
			if (i != theButton.state)
			{
				hideLayer(theButton.layerArray[i]);
			}
		}
		if ( theButton.fUp != null )
		{
			theButton.fUp(theButton.buttonId);
		}
	}
}

function fourStateButtonMouseDown(e)
{
	var theButton;
	if ( inNetscape4x )
	{
		theButton = FOUR_STATE_BUTTON_ARRAY[e];
	}
	else
	{
		theButton = this.theLayer;
	}
	
	if ( theButton.enabled )
	{
		theButton.state = FOUR_STATE_BUTTON_STATE_DOWN;
		if (theButton.isVis)
		{
			showLayer(theButton.layerArray[theButton.state]);
		}
		for (var i=0;i<theButton.layerArray.length;i++)
		{
			if (i != theButton.state)
			{
				hideLayer(theButton.layerArray[i]);
			}
		}
		if ( theButton.fUp != null )
		{
			theButton.fUp(theButton.buttonId);
		}
	}
}

function fourStateSetOnClick(fun)
{
	this.fClick = fun;
}

function fourStateSetOnMouseOver(fun)
{
	this.fOver = fun;
}

function fourStateSetOnMouseOut(fun)
{
	this.fOut = fun;
}

function fourStateSetOnMouseUp(fun)
{
	this.fUp = fun;
}

function fourStateSetOnMouseDown(fun)
{
	this.fDown = fun;
}

function setFourStateButtonState(state)
{
	var theButton = this;
	if ( theButton.enabled )
	{
		theButton.state = state;
		if (theButton.isVis)
		{
			showLayer(theButton.layerArray[theButton.state]);
		}
		for (var i=0;i<theButton.layerArray.length;i++)
		{
			if (i != theButton.state)
			{
				hideLayer(theButton.layerArray[i]);
			}
		}
	}
}

function hideFourStateButton()
{
	this.setVisibility(false);
}

function showFourStateButton()
{
	this.setVisibility(true);
}

////////////////////////
// fourStateButtonSet //
////////////////////////

function fourStateButtonSet()
{
	this.buttons = new Array();
	this.names = new Array();
	this.enabledStates = new Array();
	this.visibleStates = new Array();
	this.enabled = true;
	this.visible = true;
	
	this.add = addFourStateButtonSetButton;
	this.disableAll = fourStateButtonSetDisable;
	this.enableAll = fourStateButtonSetEnable;
	this.hideAll = hideFourStateButtonSet;
	this.showAll = showFourStateButtonSet;
	this.disable = _fourStateButtonSetDisable;
	this.enable = _fourStateButtonSetEnable;
	this.hide = _hideFourStateButtonSet;
	this.show = _showFourStateButtonSet;
}

// disable an individual button
function _fourStateButtonSetDisable(strName)
{
	if (strName == null)
	{
		this.enabled = false;
		for ( var i = 0; i < this.buttons.length; i++ )
		{
			this.buttons[i].disableButton();
		}
	}
	else
	{
		for ( var i = 0; i < this.names.length; i++ )
		{
			if (this.names[i].toLowerCase() == strName.toLowerCase())
			{
				this.enabledStates[i] = false;
				this.buttons[i].disableButton();
				break;
			}
		}
	}
}

// enable an individual button
function _fourStateButtonSetEnable(strName)
{
	if (strName == null)
	{
		this.enabled = true;
		for ( var i = 0; i < this.buttons.length; i++ )
		{
			if (this.enabledStates[i])
			{
				this.buttons[i].enableButton();
			}
		}
	}
	else
	{
		for ( var i = 0; i < this.names.length; i++ )
		{
			if (this.names[i].toLowerCase() == strName.toLowerCase())
			{
				this.enabledStates[i] = true;
				if (this.enabled)
				{
					this.buttons[i].enableButton();
				}
				break;
			}
		}
	}
}

// hide an individual button
function _hideFourStateButtonSet(strName)
{
	if (strName == null)
	{
		this.visible = false;
		for ( i = 0; i < this.buttons.length; i++ )
		{
			this.buttons[i].hide();
		}
	}
	else
	{
		for ( var i = 0; i < this.names.length; i++ )
		{
			if (this.names[i].toLowerCase() == strName.toLowerCase())
			{
				this.visibleStates[i] = false;
				this.buttons[i].hide();
				break;
			}
		}
	}
}

// show an individual button
function _showFourStateButtonSet(strName)
{
	if (strName == null)
	{
		this.visible = true;
		for ( i = 0; i < this.buttons.length; i++ )
		{
			if (this.visibleStates[i])
			{
				this.buttons[i].show();
			}
		}
	}
	else
	{
		for ( var i = 0; i < this.names.length; i++ )
		{
			if (this.names[i].toLowerCase() == strName.toLowerCase())
			{
				this.visibleStates[i] = true;
				if (this.visible)
				{
					this.buttons[i].show();
				}
				break;
			}
		}
	}
}

function fourStateButtonSetDisable()
{
	for ( var i = 0; i < this.buttons.length; i++ )
	{
		this.enabledStates[i] = false;
		this.buttons[i].disableButton();
	}
}

function fourStateButtonSetEnable()
{
	for ( var i = 0; i < this.buttons.length; i++ )
	{
		this.enabledStates[i] = true;
		if (this.enabled)
		{
			this.buttons[i].enableButton();
		}
	}
}

function addFourStateButtonSetButton(buttonName, buttonType, altText)
{
	this.buttons[this.buttons.length] = new fourStateButton(buttonName, buttonType, altText);
	this.names[this.names.length] = buttonName;
	this.enabledStates[this.enabledStates.length] = true;
	
	return this.buttons[this.buttons.length-1];
}

function hideFourStateButtonSet()
{
	for ( var i = 0; i < this.buttons.length; i++ )
	{
		this.visibleStates[i] = false;
		this.buttons[i].hide();
	}
}

function showFourStateButtonSet()
{
	for ( var i = 0; i < this.buttons.length; i++ )
	{
		this.visibleStates[i] = true;
		if (this.visible)
		{
			this.buttons[i].show();
		}
	}
}
